local function UpdateText(self, deltaTime)
	local musicPos = GAMESTATE:GetPlayerState(GAMESTATE:GetMasterPlayerNumber()):GetSongPosition()
	local songRateMod = GAMESTATE:GetSongOptionsObject("ModsLevel_Current"):MusicRate()
	
	self:GetChild("Playback"):GetChild("SongTime"):settextf("SONG TIME: %.3f", musicPos:GetMusicSeconds())
	-- bad implementation...
	if songRateMod ~= 1 then
		self:GetChild("Playback"):GetChild("BPM"):settextf("CUR. BPM: %.3f\n(%.1fx)", (musicPos:GetCurBPS()*60)*songRateMod, songRateMod)
	else
		self:GetChild("Playback"):GetChild("BPM"):settextf("CUR. BPM: %.3f", musicPos:GetCurBPS()*60)
	end
end

return Def.ActorFrame{
	InitCommand=cmd(SetUpdateFunction,UpdateText),
	
	-- Things that only show during playback.
	Def.ActorFrame {
		Name = "Playback",
		ShowCommand=cmd(visible,true),
		HideCommand=cmd(visible,false),
		EditCommand=cmd(playcommand,"Hide"),
		PlayingCommand=cmd(playcommand,"Show"),
		RecordCommand=cmd(playcommand,"Show"),
		RecordPausedCommand=cmd(playcommand,"Show"),
		
		LoadActor("SongProgress") .. {
			OnCommand=function(self)
				self:xy(_screen.cx,18)
			end
		},
		
		Def.BitmapText{
			Font = "Common Normal",
			Name = "SongTime",
			InitCommand=cmd(horizalign,left;vertalign,top;zoom,0.6;x,20;y,10;strokecolor,Color.Black)
		},
		Def.BitmapText{
			Font = "Common Normal",
			Name = "BPM",
			InitCommand=cmd(horizalign,right;vertalign,top;zoom,0.6;x,_screen.w-20;y,10;strokecolor,Color.Black)
		}
	},
	
	-- Things that only show on the main edit screen.
	Def.ActorFrame{
		Name = "Edit",
		ShowCommand=cmd(visible,true),
		HideCommand=cmd(visible,false),
		EditCommand=cmd(playcommand,"Show"),
		PlayingCommand=cmd(playcommand,"Hide"),
		RecordCommand=cmd(playcommand,"Hide"),
		RecordPausedCommand=cmd(playcommand,"Hide"),
	}
}